{include file="header_dash.tpl" meta_title="Main Plans | {$settings.site_name}"}

<div class="container-fluid mb-5">
                <!-- Title -->
    <h1 class="h2">
        Withdraw From Your Account.
    </h1>
    <p>Place a Withdrawal Request Using any of the Payment Method Below.</p>
    {literal}<div wire:id="4QszCnnODqKfAwjE5MfR" wire:initial-data="{&quot;fingerprint&quot;:{&quot;id&quot;:&quot;4QszCnnODqKfAwjE5MfR&quot;,&quot;name&quot;:&quot;user.investment-plan&quot;,&quot;locale&quot;:&quot;en&quot;,&quot;path&quot;:&quot;dashboard\/buy-plan&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;v&quot;:&quot;acj&quot;},&quot;effects&quot;:{&quot;listeners&quot;:[]},&quot;serverMemo&quot;:{&quot;children&quot;:[],&quot;errors&quot;:[],&quot;htmlHash&quot;:&quot;2a20f489&quot;,&quot;data&quot;:{&quot;planSelected&quot;:[],&quot;amountToInvest&quot;:0,&quot;disabled&quot;:&quot;disabled&quot;,&quot;paymentMethod&quot;:&quot;Account Balance&quot;,&quot;feedback&quot;:&quot;&quot;},&quot;dataMeta&quot;:{&quot;models&quot;:{&quot;planSelected&quot;:{&quot;class&quot;:&quot;App\\Models\\Plans&quot;,&quot;id&quot;:14,&quot;relations&quot;:[],&quot;connection&quot;:&quot;mysql&quot;}}},&quot;checksum&quot;:&quot;428306aefcca02641ed691e39e4679e5ae05faa63c81f5188baa3e3a9bb8d0b9&quot;}}">{/literal}


{if $say eq 'processed'}
<div class="alert alert-success">{if $batch eq ''}Withdrawal request has been successfully saved.{else} Withdrawal has been processed. Batch id: {$batch}{/if}</div>
{/if}

{if $fatals}
  {if $fatal == 'times_limit' || $fatals.times_limit}
  <div class="error">You can withdraw {$settings.limit_withdraw_period_times} per {$settings.limit_withdraw_period_date} only.</div>
  {/if}

{else}

{if $errors.ec_forbidden}<div class="error">Sorry, withdraw for this processing is temproary forbidden.</div>{/if}
{if $errors.on_hold}<div class="error">Sorry, this amount on hold now.</div>{/if}
{if $errors.zero}Sorry, you can't request a withdraw smaller than {$currency_sign}0.00 only</div>{/if}
{if $errors.less_min}<div class="error">Sorry, you can request not less than {$fees.amount_min|fiat}</div>{/if}
{if $errors.greater_max}<div class="error">Sorry, you can request not greater than {$fees.amount_max|fiat}</div>{/if}
{if $errors.daily_limit}<div class="error">Sorry, you have exceeded a daily limit</div>{/if}
{if $errors.not_enought}<div class="error">Sorry, you have requested the amount larger than the one on your balance.</div>{/if}
{if $errors.invalid_transaction_code}<div class="error">You have entered the invalid transaction code.</div>{/if}
{if $errors.invalid_tfa_code}<div class="error">You have entered invalid 2FA code.</div>{/if}
{if $errors.no_deposits}<div class="error">You have not done any deposits yet. Withdrawal function will be available after a deposit.</div>{/if}
{if $errors.no_active_deposits}<div class="error">You must have active deposit to withdraw.</div>{/if}
{if $errors.no_account}<div class="error">Please, provide your account to withdraw funds to first <a href="{"?a=edit_account"|encurl}">here</a>.</div>{/if}
{if $errors.demo}<div class="error">Withdraw is not available for demo account.</div>{/if}
{if $errors.turing_image}<div class="error">Invalid turing image</div>{/if}
{if $errors.account_suspended}<div class="error">Account is suspended</div>{/if}

{if $preview}

<form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=withdraw>
<input type=hidden name=amount value={$amount}>
<input type=hidden name=ec value={$ec}>
<input type=hidden name=comment value="{$comment|escape:html}">
<div class="card">
            <div class="card-body">
<div class="table-responsive">
<table cellspacing=0 cellpadding=2 border=0 class="table">
<tr>
 <th>Payment System:</th>
 <td>{$currency}</td>
</tr>
<tr>
 <th>Wallet:</th>
 <td>{$account}</td>
</tr>
<tr>
 <th>Debit Amount:</th>
 <td>{$amount|fiat:$ec}</td>
</tr>
<tr>
 <th>Withdrawal Fee:</th>
 <td>
{if $fees.fee > 0}
  {$fees.percent}% + {$fees.add_amount|fiat:$ec} (min. {$fees.fee_min|fiat:$ec} max. {if $fees.fee_max}{$fees.fee_max|fiat:$ec}{else}no{/if})
{else}
We have no fee for this operation.
{/if}
</td>
</tr>

{if $converted}
<tr>
 <th>Credit Amount:</th>
 <td>{$converted.amount|fiat:$ec}</td>
</tr>
<tr>
 <th>{$converted.fiat} Amount:</th>
 <td>{$to_withdraw}</td>
</tr>
{else}
<tr>
 <th>Credit Amount:</th>
 <td>{$to_withdraw|fiat:$ec}</td>
</tr>
{/if}

{if $comment}
<tr>
 <th>Note:</th>
 <td>{$comment|escape:html}</td>
</tr>
{/if}
{if $settings.use_transaction_code && $userinfo.transaction_code}
<tr>
 <th>Transaction Code:</th>
 <td><input type="password" name="transaction_code" class=inpts size=15></td>
</tr>
{/if}
{include file="captcha.tpl" action="withdrawal"}
{if $userinfo.tfa_settings.withdraw}
<tr>
 <th>2FA Code:</th>
 <td><input type="text" name="tfa_code" class=inpts size=15> <input type="hidden" name="tfa_time" id="tfa_time"></td>
</tr>
{literal}
<script language=javascript>
document.getElementById('tfa_time').value = (new Date()).getTime();
</script>
{/literal}
{/if}
<tr>
 <td colspan=2><input type=submit value="Confirm" class="btn btn-primary"></td>
</tr></table>
</div>
</div>
</div>
</form>


{else}


<form method=post>
<input type=hidden name=a value=withdraw>
<input type=hidden name=action value=preview>
<input type=hidden name=say value="">


<div class="row">
    <div class="col-md-7">
        <div class="card">
            <div class="card-body">
<div class="mt-5">
    <p class="mb-2">Choose Payment Method</p>
</div>                
<select name=ec class="form-control w-100">
{assign var="wfch" value=1}
{foreach from=$ps item=p}
<option value="{$p.id}">{$p.name|escape:html} - {$p.available|fiat:$p.ec}</option>
{/foreach}
</select>

{if $have_available}
<div class="mt-5">
    <p class="mb-2">Enter Your Amount</p>
    <input type="text"  name="amount" value='{$frm.amount|amount_format|default:"10.00"}' class="form-control d-block w-100" >
</div>
<button class="btn btn-primary mt-5">
    Request
    <i class="bi bi-arrow-right"></i>
</button>

{else}
<br><br>
<div class="alert alert-danger">You have no funds to withdraw.</div>
{/if}
</div>
</div>
</div>
<div class="col-md-5">
    <div class="card">
            <div class="card-body">
<div class="table-responsive">
<table cellspacing=0 cellpadding=2 border=0 class="table">
<tr>
 <th>Processing</th> 
 <th>Wallet</th>
</tr>
{assign var="wfch" value=1}
{foreach from=$ps item=p}
<tr>
 <td><img src="images/{$p.id}.gif" width=30 align=absmiddle> {$p.name|escape:html}</td> 
 <td>{if $p.account != ''}{$p.account|escape:html}{else}<a href="{"?a=edit_account"|encurl}"><i>not set</i></a>{/if}</td>
</tr>
{/foreach}
</table>
</div>    
</div>
</div>
</div>
</form>

{/if}

{/if}

</div>
<style>
    .form-control {
        font-size: 16px;
    }
</style>
{include file="footer_dash.tpl"}
